#include "pch.h"
#include "Temp.hpp"

int   Len;

bool GetNextName(LPTSTR szName) {
    int i, j;

    i = Len-1;
    j = 0;

    while (j <= 2) {
        if (szName[i] < _T('0')) {
            szName[i] = _T('0');
            break;
        }
    
        if (szName[i] < _T('9')) {
            szName[i]++;
            break;
        }
    
        if (szName[i] < _T('A')) {
            szName[i] = _T('a');
            break;
        }
        
        if (szName[i] < _T('Z')) {
            szName[i]++;
            szName[i] += _T('a') - _T('A');
            break;
        }
    
        if (szName[i] < _T('a')) {
            szName[i] = _T('a');
            break;
        }
    
        if (szName[i] < _T('z')) {
            szName[i]++;
            break;
        }

        szName[i] = _T('0');
        i--;
        j++;
    }

    return (j <= 2);
}

HANDLE GetTempFile(LPTSTR szTempFileName, DWORD dwAccess ) {
	HANDLE	hFile;
	bool	fNotLastNamePassed;

	Len = lstrlen( szTempFileName );

	fNotLastNamePassed = true;
	do {
		hFile = CreateFile( szTempFileName, dwAccess, 0, NULL, CREATE_NEW, FILE_ATTRIBUTE_HIDDEN, NULL );
		if (hFile != INVALID_HANDLE_VALUE)
			break;
		fNotLastNamePassed = GetNextName( szTempFileName );
	} while (fNotLastNamePassed);

	return (hFile);
}

bool GetTmpFileName(LPTSTR szTempFileName) {
    bool   fNotLastNamePassed;
    Len = lstrlen( szTempFileName );

    fNotLastNamePassed = true;
    do {
        if (_taccess( szTempFileName, 0) != 0)
            break;
        fNotLastNamePassed = GetNextName( szTempFileName );
    } while (fNotLastNamePassed);
    return (fNotLastNamePassed);
}


tstring getTempFileName(const tstring& path, const tstring& prefix) {
	TCHAR	buffer[MAX_PATH];
	UINT	uniqueNumber = ::GetTempFileName( path.c_str(), prefix.c_str(), 0, buffer );
	if (uniqueNumber <= 0) {
		// failed to get temporary file name
		return tstring();
	}
	else {
		// we have a name
		return tstring( buffer );
	}
}
